package ru.yandex.travel.orders.services.payments.schedule;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.promo.mir.MirEligibilityService;
import ru.yandex.travel.hotels.common.schedule.PaymentScheduleHotelList;
import ru.yandex.travel.hotels.common.schedule.PaymentScheduleHotelListImpl;

@Configuration
@EnableConfigurationProperties(HotelPaymentScheduleBuilderProperties.class)
@RequiredArgsConstructor
@Slf4j
public class HotelPaymentScheduleBuilderConfiguration {
    private final HotelPaymentScheduleBuilderProperties properties;

    @Bean
    @ConditionalOnProperty("payment-schedule.hotels.hotel-lists.enabled")
    public PaymentScheduleHotelList paymentScheduleHotelList() {
        PaymentScheduleHotelListImpl paymentScheduleHotelList =
                new PaymentScheduleHotelListImpl(properties.getHotelLists());
        paymentScheduleHotelList.start();
        return paymentScheduleHotelList;
    }

    @Bean
    @ConditionalOnMissingBean(PaymentScheduleHotelList.class)
    public PaymentScheduleHotelList dummyPaymentScheduleHotelList() {
        log.warn("PaymentScheduleHotelList is disabled. " +
                "All enabled partners will return all their hotels as eligible for deferred payments");
        return (partnerId, originalId) -> true;
    }

    @Bean
    @ConditionalOnProperty("payment-schedule.hotels.hotel-lists.enabled")
    public HealthIndicator paymentScheduleHotelList(PaymentScheduleHotelListImpl paymentScheduleHotelList) {
        return () -> {
            if (paymentScheduleHotelList.isHealthy()) {
                return Health.up().build();
            } else {
                return Health.down().build();
            }
        };
    }

    @Bean
    public HotelPaymentScheduleBuilder hotelPaymentScheduleBuilder(MirEligibilityService mirEligibilityService,
                                                                   PaymentScheduleHotelList paymentScheduleHotelList) {
        return new HotelPaymentScheduleBuilder(properties, mirEligibilityService, paymentScheduleHotelList);
    }
}
