package ru.yandex.travel.orders.services.payments.schedule;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.schedule.PaymentScheduleProperties;

@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties(value = "payment-schedule.hotels", ignoreUnknownFields = false)
@Data
@Validated
public class HotelPaymentScheduleBuilderProperties extends PaymentScheduleProperties {
    @NotNull
    private Duration emailInterval;
    @NotNull
    private Duration ticketInterval;
    @NotNull
    private Duration autoPaymentInterval;
}
