package ru.yandex.travel.orders.services.payments.schedule;

import java.math.BigDecimal;
import java.time.Instant;

import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.entities.OrderItem;

@Value
@Builder
public class PaymentScheduleBuilderRule {
    private String name;
    private BigDecimal ratio;
    private Instant paymentEndsAt;
    private Instant emailReminderAt;
    private Instant ticketReminderAt;
    private OrderItem orderItem;
    private Money penaltyIfUnpaid;
}
