package ru.yandex.travel.orders.services.pdfgenerator;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@Setter
@Getter
@ConfigurationProperties(value = "pdfgenerator")
public class PdfGeneratorConfigurationProperties {
    @NotEmpty
    private String baseUrl;
    @NotNull
    private Duration longRequestTimeout;
    @NotNull
    private Duration longReadTimeout;
    @NotNull
    private Duration quickRequestTimeout;
    @NotNull
    private Duration quickReadTimeout;
}
