package ru.yandex.travel.orders.services.promo;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.commons.proto.EPromoCodeApplicationResultType;


@RequiredArgsConstructor
public enum ApplicationResultType {
    SUCCESS(EPromoCodeApplicationResultType.ART_SUCCESS, ""),
    NOT_FOUND(EPromoCodeApplicationResultType.ART_NOT_FOUND, ""),
    NOT_APPLICABLE(EPromoCodeApplicationResultType.ART_NOT_APPLICABLE, "Promo code %s is blacklisted"),
    EMPTY_BUDGET(EPromoCodeApplicationResultType.ART_EMPTY_BUDGET, ""),
    EXPIRED(EPromoCodeApplicationResultType.ART_EXPIRED, "Activation dates for promo code %s has ended"),
    ALREADY_APPLIED(EPromoCodeApplicationResultType.ART_ALREADY_APPLIED, "Promo code %s has no activations left"),
    // we need more statuses inside the application, but changing external interface seems unnecessary at the moment
    // therefore some proto values are reused
    NOT_STARTED(EPromoCodeApplicationResultType.ART_NOT_FOUND, "Activation dates for promo code %s has not started"),
    ;

    @Getter
    private final EPromoCodeApplicationResultType protoValue;
    private final String errorFormat;

    public String getErrorMessage(String promoCode) {
        return String.format(errorFormat, promoCode);
    }

}
