package ru.yandex.travel.orders.services.promo;


import lombok.Value;
import org.javamoney.moneta.Money;

@Value
public class CodeApplicationResult {
    private final String code;
    private final ApplicationResultType type;
    private final Money discountAmount;

    public static CodeApplicationResult success(String code, Money discountAmount) {
        return new CodeApplicationResult(code, ApplicationResultType.SUCCESS, discountAmount);
    }

    public static CodeApplicationResult notApplicable(String code) {
        return new CodeApplicationResult(code, ApplicationResultType.NOT_APPLICABLE, null);
    }

    public static CodeApplicationResult alreadyApplied(String code) {
        return new CodeApplicationResult(code, ApplicationResultType.ALREADY_APPLIED, null);
    }

    public static CodeApplicationResult expired(String code) {
        return new CodeApplicationResult(code, ApplicationResultType.EXPIRED, null);
    }

    public static CodeApplicationResult notFound(String code) {
        return new CodeApplicationResult(code, ApplicationResultType.NOT_FOUND, null);
    }

    public static CodeApplicationResult emptyBudget(String code) {
        return new CodeApplicationResult(code, ApplicationResultType.EMPTY_BUDGET, null);
    }

}
