package ru.yandex.travel.orders.services.promo;

import java.util.Map;

import lombok.Getter;
import lombok.ToString;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.entities.FiscalItem;

@ToString
public class FiscalItemApplicationResult {
    @Getter
    private final ApplicationResultType resultType;
    //TODO (mbobrov): we'll need to switch to list of tuples here
    @Getter
    private final Map<FiscalItem, Money> discountMap;

    private FiscalItemApplicationResult(ApplicationResultType resultType, Map<FiscalItem, Money> discountMap) {
        this.resultType = resultType;
        this.discountMap = discountMap;
    }

    public static FiscalItemApplicationResult success(Map<FiscalItem, Money> discountMap) {
        return new FiscalItemApplicationResult(ApplicationResultType.SUCCESS, discountMap);
    }

    public static FiscalItemApplicationResult notApplicable() {
        return new FiscalItemApplicationResult(ApplicationResultType.NOT_APPLICABLE, null);
    }

    public static FiscalItemApplicationResult emptyBudget() {
        return new FiscalItemApplicationResult(ApplicationResultType.EMPTY_BUDGET, null);
    }
}
