package ru.yandex.travel.orders.services.promo;

import java.util.Map;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;

public class PromoCodeUnifier {

    private static final Map<Character, Character> SUBSTITUTIONS = ImmutableMap.<Character, Character>builder()
            .put('0', 'O')
            .put('О', 'O')
            .put('1', 'I')
            .build();

    public static String unifyCode(String input) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(input), "Input must be not null and not empty");
        StringBuilder builder = new StringBuilder();
        for (Character ch : input.toCharArray()) {
            Character r = Character.toUpperCase(ch);
            r = SUBSTITUTIONS.getOrDefault(r, r);
            builder.append(r);
        }
        return builder.toString();
    }
}
