package ru.yandex.travel.orders.services.promo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.orders.commons.proto.EServiceType;


@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ServiceDescription {
    private String id;
    private EServiceType serviceType;
    private Object payload;
    private Money fiscalPrice;
    private Money originalCost;

    public void setPayload(Object payload) {
        if (payload instanceof HotelItinerary) {
            var itinerary = (HotelItinerary) payload;
            this.originalCost = itinerary.getPriceAfterDiscount();
            this.fiscalPrice = itinerary.getFiscalPrice();
        }
        this.payload = payload;
    }
}
