package ru.yandex.travel.orders.services.promo.aeroflotplus;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.management.metrics.GaugeServiceDbMetric;
import ru.yandex.travel.orders.management.metrics.GaugeServiceSimpleDbMetric;
import ru.yandex.travel.orders.repository.promo.aeroflotplus.AeroflotPlusPromoCodeRepository;

@Configuration
public class AeroflotPlusPromoMetricsConfiguration {
    @Bean
    public GaugeServiceDbMetric aeroflotPlusFreePromoCodesMetric(AeroflotPlusPromoCodeRepository repository) {
        return new GaugeServiceSimpleDbMetric("promoCampaigns.aeroflotPlus", "freePromoCodes") {
            @Override
            public double getValue() {
                return repository.countByUsedAtIsNull();
            }
        };
    }
}
