package ru.yandex.travel.orders.services.promo.aeroflotplus;

import java.time.Instant;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(value = "aeroflot-plus-promo", ignoreUnknownFields = false)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class AeroflotPlusPromoProperties {
    @NotNull
    private Instant startsAt;
    @NotNull
    private Instant endsAt;
    @NotEmpty
    private String emailCampaign;
}
