package ru.yandex.travel.orders.services.promo.campaigns;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.hotels.models.booking_flow.promo.WhiteLabelPromoCampaign;
import ru.yandex.travel.orders.entities.promo.mir2020.Mir2020PromoOrder;
import ru.yandex.travel.orders.entities.promo.taxi2020.Taxi2020PromoOrder;

/**
 * DTO for creating {@link ru.yandex.travel.orders.admin.proto.TOrderPromoCampaignsInfo}
 * and {@link ru.yandex.travel.orders.proto.TPromoCampaignsInfo} in
 * {@link ru.yandex.travel.orders.services.OrderInfoMapper}
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PromoCampaigns {
    private Taxi2020PromoOrder taxi2020;
    private Mir2020PromoOrder mir2020;
    private WhiteLabelPromoCampaign whiteLabel;
}
