package ru.yandex.travel.orders.services.promo.campaigns;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.services.promo.mir2020.Mir2020PromoService;
import ru.yandex.travel.orders.services.promo.taxi2020.Taxi2020PromoService;
import ru.yandex.travel.orders.services.promo.white_label.WhiteLabelPromoService;
import ru.yandex.travel.tx.utils.TransactionMandatory;

@Service
@RequiredArgsConstructor
public class PromoCampaignsService {
    private final Taxi2020PromoService taxi2020PromoService;
    private final Mir2020PromoService mir2020PromoService;
    private final WhiteLabelPromoService whiteLabelPromoService;

    @TransactionMandatory
    public PromoCampaigns getOrderPromoCampaignsParticipationInfo(Order order) {
        PromoCampaigns campaigns = new PromoCampaigns();
        if (order instanceof HotelOrder) {
            campaigns.setTaxi2020(taxi2020PromoService.getPromoParticipationStatus((HotelOrder) order));
            campaigns.setMir2020(mir2020PromoService.getPromoParticipationStatus((HotelOrder) order));
            campaigns.setWhiteLabel(whiteLabelPromoService.getPromoParticipationStatus((HotelOrder) order));
        }
        return campaigns;
    }
}
