package ru.yandex.travel.orders.services.promo.export;

import java.util.Iterator;
import java.util.List;

import javax.persistence.EntityManager;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;

import ru.yandex.travel.orders.entities.UserOrderCounter;
import ru.yandex.travel.orders.repository.UserOrderCounterRepository;
import ru.yandex.travel.user_order_counters.proto.TUserOrderCounter;

@Slf4j
public class UserOrderCounterYtExporter extends AbstractUserOrderCounterYtExporter<TUserOrderCounter> {

    public UserOrderCounterYtExporter(UserOrderCounterYtExporterProperties userOrderCounterYtExporterProperties,
                                      UserOrderCounterRepository userOrderCounterRepository,
                                      EntityManager entityManager) {
        super(userOrderCounterYtExporterProperties, userOrderCounterRepository, entityManager,
                "UserOrderCountersYtExporter", TUserOrderCounter.getDefaultInstance());
    }

    @Override
    public Iterator<TUserOrderCounter> mapUserOrderCountersToProto(List<UserOrderCounter> countersBatch) {
        return countersBatch.stream()
                .map(uc -> TUserOrderCounter.newBuilder()
                        .setPassportId(uc.getPassportId())
                        .setConfirmedHotelOrders(uc.getConfirmedHotelOrders())
                        .build())
                .iterator();
    }

    @Override
    protected List<UserOrderCounter> getCountersBatch(PageRequest pageRequest) {
        return userOrderCounterRepository.findNextUserOrderCounterWithHotelOrders(pageRequest);
    }
}
