package ru.yandex.travel.orders.services.promo.export;

import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Data;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Data
@Validated
public class UserOrderCounterYtExporterPropertiesBase {
    @NotEmpty
    private String token;
    @NotNull
    private Duration transactionDuration;

    @NotEmpty
    private List<String> clusters;

    @NotEmpty
    private String userOrderCountersTablePath;

    @Positive
    private int dbBatchSize;

    @NotNull
    private TaskProcessorProperties taskProcessor;
}
