package ru.yandex.travel.orders.services.promo.export;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;

import ru.yandex.travel.clients.promo_service_booking_flow.PromoServiceBookingFlowUtils;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.entities.UserOrderCounter;
import ru.yandex.travel.orders.repository.UserOrderCounterRepository;
import ru.yandex.travel.user_order_counters.proto.TUserOrderCounterByType;

@Slf4j
public class UserOrderCountersByTypeYtExporter extends AbstractUserOrderCounterYtExporter<TUserOrderCounterByType> {
    private static final Set<EDisplayOrderType> orderTypes = Set.of(
            EDisplayOrderType.DT_HOTEL,
            EDisplayOrderType.DT_AVIA,
            EDisplayOrderType.DT_TRAIN,
            EDisplayOrderType.DT_BUS,
            EDisplayOrderType.DT_SUBURBAN
    );

    public UserOrderCountersByTypeYtExporter(UserOrderCounterByTypeYtExporterProperties userOrderCounterYtExporterProperties,
                                             UserOrderCounterRepository userOrderCounterRepository,
                                             EntityManager entityManager) {
        super(userOrderCounterYtExporterProperties, userOrderCounterRepository, entityManager,
                "UserOrderCountersByTypeYtExporter", TUserOrderCounterByType.getDefaultInstance());
    }

    @Override
    protected Iterator<TUserOrderCounterByType> mapUserOrderCountersToProto(List<UserOrderCounter> countersBatch) {
        return countersBatch.stream()
                .flatMap(uc -> orderTypes.stream()
                        .filter(orderType -> uc.getConfirmedOrders(orderType) != 0)
                        .map(orderType -> TUserOrderCounterByType.newBuilder()
                                .setPassportId(uc.getPassportId())
                                .setOrderType(PromoServiceBookingFlowUtils.mapDisplayOrderTypeToOrderType(orderType))
                                .setOrderCount(uc.getConfirmedOrders(orderType))
                                .build()))
                .iterator();
    }

    @Override
    protected List<UserOrderCounter> getCountersBatch(PageRequest pageRequest) {
        return userOrderCounterRepository.findAll(pageRequest).toList();
    }
}
