package ru.yandex.travel.orders.services.promo.export;

import javax.persistence.EntityManager;

import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.travel.orders.repository.UserOrderCounterRepository;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.RegularTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;

@Configuration
@EnableConfigurationProperties({
        UserOrderCounterYtExporterProperties.class,
        UserOrderCounterByTypeYtExporterProperties.class
})
@AllArgsConstructor
public class UserOrderCountersYtExporterConfig {

    private final UserOrderCounterYtExporterProperties userOrderCounterYtExporterProperties;

    private final UserOrderCounterByTypeYtExporterProperties userOrderCounterByTypeYtExporterProperties;

    private final UserOrderCounterRepository userOrderCounterRepository;

    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    private final EntityManager entityManager;

    @Bean
    public UserOrderCounterYtExporter userOrderCounterYtExporter() {
        return new UserOrderCounterYtExporter(
                userOrderCounterYtExporterProperties,
                userOrderCounterRepository,
                entityManager);
    }

    @Bean
    public UserOrderCountersByTypeYtExporter userOrderCounterByTypeYtExporter() {
        return new UserOrderCountersByTypeYtExporter(
                userOrderCounterByTypeYtExporterProperties,
                userOrderCounterRepository,
                entityManager);
    }

    @Bean
    @ConditionalOnProperty("user-order-counters-yt-exporter.task-processor.enabled")
    public TaskProcessor<String> userOrderCounterYtExporterTaskProcessor(
            UserOrderCounterYtExporter userOrderCounterYtExporter
    ) {
        TaskKeyProvider<String> taskKeyProvider = new RegularTaskKeyProvider<>(userOrderCounterYtExporter.getTaskKey());

        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName("UserOrderCountersYtExporter");
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        TransactionDefinition txDefinition = new DefaultTransactionDefinition(transactionDefinition);

        return new TaskProcessor<>(
                taskKeyProvider,
                userOrderCounterYtExporter::exportUserOrderCounterToYt,
                forcedRollbackTxManagerWrapper,
                txDefinition,
                userOrderCounterYtExporterProperties.getTaskProcessor()
        );
    }

    @Bean
    @ConditionalOnProperty("user-order-counters-by-type-yt-exporter.task-processor.enabled")
    public TaskProcessor<String> userOrderCounterByTypeYtExporterTaskProcessor(
            UserOrderCountersByTypeYtExporter userOrderCountersByTypeYtExporter
    ) {
        TaskKeyProvider<String> taskKeyProvider = new RegularTaskKeyProvider<>(userOrderCountersByTypeYtExporter.getTaskKey());

        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName("UserOrderCountersByTypeYtExporter");
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        TransactionDefinition txDefinition = new DefaultTransactionDefinition(transactionDefinition);

        return new TaskProcessor<String>(
                taskKeyProvider,
                userOrderCountersByTypeYtExporter::exportUserOrderCounterToYt,
                forcedRollbackTxManagerWrapper,
                txDefinition,
                userOrderCounterByTypeYtExporterProperties.getTaskProcessor()
        );
    }
}
