package ru.yandex.travel.orders.services.promo.mir2020;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.promo.mir.MirEligibilityService;
import ru.yandex.travel.hotels.common.promo.mir.MirHotelList;
import ru.yandex.travel.hotels.common.promo.mir.MirHotelListImpl;
import ru.yandex.travel.hotels.common.promo.mir.MirWhitelistHealthIndicator;

@Configuration
@Slf4j
@EnableConfigurationProperties(Mir2020ConfigurationProperties.class)
public class Mir2020Configuration {
    @Bean
    @ConditionalOnProperty("promo.mir2020.whitelist.enabled")
    public MirHotelList mirWhitelist(Mir2020ConfigurationProperties properties) {
        MirHotelListImpl mirWhitelist = new MirHotelListImpl(properties.getWhitelist());
        mirWhitelist.start();
        return mirWhitelist;
    }

    @Bean
    @ConditionalOnMissingBean(MirHotelList.class)
    public MirHotelList dummyWhitelist() {
        log.warn("Running MirEligibilityService without whitelist");
        return (partnerId, hotelId) -> null;
    }

    @Bean
    @ConditionalOnProperty("promo.mir2020.whitelist.enabled")
    public MirWhitelistHealthIndicator mirWhitelistHealthIndicator(MirHotelList mirHotelList) {
        return new MirWhitelistHealthIndicator((MirHotelListImpl) mirHotelList);
    }


    @Bean
    public MirEligibilityService mirEligibilityService(Mir2020ConfigurationProperties properties,
                                                       MirHotelList whitelist) {
        return new MirEligibilityService(properties, whitelist, "promo.mir.offers");
    }
}
