package ru.yandex.travel.orders.services.promo.mir2020;

import java.time.Duration;
import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.promo.mir.MirProperties;


@Data
@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties("promo.mir2020")
@Validated
public class Mir2020ConfigurationProperties extends MirProperties {
    @NotEmpty
    private Set<String> cardTypes;

    @NotNull
    @Valid
    private Support support;

    @Data
    @Validated
    public static class Support {
        private boolean enabled;
        @NotNull
        private Duration minFreeRefundRemaining;
        @NotNull
        private Duration notificationDelay;

    }

}
