package ru.yandex.travel.orders.services.promo.simple;

import lombok.Builder;
import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.services.MailSenderService;
import ru.yandex.travel.workflow.single_operation.SingleOperationRunner;

@Service
@RequiredArgsConstructor
@Slf4j
public class PromoSendMailOperation implements SingleOperationRunner<PromoSendMailData, Void> {
    private final MailSenderService mailSenderService;

    @Override
    public Class<PromoSendMailData> getInputClass() {
        return PromoSendMailData.class;
    }

    @Override
    public Void runOperation(PromoSendMailData params) {
        try (NestedMdc ignored = NestedMdc.forEntity(params.getParentEntityId(), params.getParentEntityType())) {
            log.info("Starting send email for {} promo", params.getPromoCampaignName());

            var args = PromoCodeEmailArgs.builder()
                    .code(params.getPromoCode())
                    .nominalType(params.getCodeNominalType())
                    .nominal(params.getCodeNominal())
                    .minTotalCost(params.getCodeMinTotalCost())
                    .validTill(params.getCodeValidTill())
                    .addsUpWithOtherActions(params.isCodeAddsUpWithOtherActions())
                    .stationToSettlementGeoId(params.getStationToSettlementGeoId())
                    .build();
            mailSenderService.sendEmailSync(params.getEmailCampaign(), params.getEmail(), null, null, null, args, null);

            log.info("{} promo code has been sent (asynchronously)", params.getPromoCampaignName());
            return null;
        }
    }

    @Value
    @Jacksonized
    @Builder
    private static class PromoCodeEmailArgs {
        String code;
        String nominalType;
        Integer nominal;
        Integer minTotalCost;
        String validTill;
        boolean addsUpWithOtherActions;
        Integer stationToSettlementGeoId;
    }
}
