package ru.yandex.travel.orders.services.promo.taxi2020;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;
import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Configuration
@ConditionalOnProperty("promo.taxi2020-scheduler-task.enabled")
@RequiredArgsConstructor
public class Taxi2020PromoSchedulerTaskConfiguration {
    @ConfigurationProperties(value = "promo.taxi2020-scheduler-task", ignoreUnknownFields = false)
    @Bean
    public TaskProcessorProperties taxi2020PromoSchedulerTaskProcessorProperties() {
        return TaskProcessorProperties.builder()
                .name("Taxi2020PromoScheduler")
                .daemonPoolThreads(true)
                .gracefulPoolShutdown(true)
                .build();
    }

    @Bean
    public TaskProcessor<String> taxi2020PromoSchedulerTaskProcessor(
            @Qualifier("taxi2020PromoSchedulerTaskProcessorProperties") TaskProcessorProperties properties,
            Taxi2020PromoService promoService,
            ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper
    ) {
        TaskKeyProvider<String> taskKeyProvider = TaskProcessorHelper.createTaskKeyProvider(
                (activeTasks, limit) -> promoService.findOrderIdsWaitingForProcessing(activeTasks),
                (activeTasks) -> promoService.countOrdersWaitingForProcessing()
        );
        return new TaskProcessor<>(taskKeyProvider,
                promoService::processOrdersBatch,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("taxi2020PromoSchedulerTaskTxDef"),
                properties
        );
    }
}
