package ru.yandex.travel.orders.services.promo.taxi2020;

import java.time.Instant;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.entities.promo.taxi2020.Taxi2020PromoOrder;
import ru.yandex.travel.orders.entities.promo.taxi2020.Taxi2020PromoOrderStatus;
import ru.yandex.travel.orders.repository.promo.taxi2020.Taxi2020PromoOrderRepository;
import ru.yandex.travel.orders.services.MailSenderService;
import ru.yandex.travel.utils.ClockService;
import ru.yandex.travel.workflow.single_operation.SingleOperationRunner;

import static ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType.HOTEL_ORDER;

@Service
@RequiredArgsConstructor
@Slf4j
public class Taxi2020PromoSendMailOperation implements SingleOperationRunner<Taxi2020PromoSendMailData, Void> {
    private final Taxi2020PromoServiceProperties properties;
    private final MailSenderService mailSenderService;
    private final Taxi2020PromoOrderRepository promoOrderRepository;
    private final ClockService clockService;

    @Override
    public Class<Taxi2020PromoSendMailData> getInputClass() {
        return Taxi2020PromoSendMailData.class;
    }

    @Override
    public Void runOperation(Taxi2020PromoSendMailData params) {
        try (NestedMdc ignored = NestedMdc.forEntity(params.getOrderId(), HOTEL_ORDER.getDiscriminatorValue())) {
            log.info("Starting the actual send email call for Taxi 2020 promo order");
            Taxi2020PromoOrder promoOrder = promoOrderRepository.getOne(params.getOrderId());

            PromoCodeEmailArgs args = new PromoCodeEmailArgs(params.getPromoCode());
            mailSenderService.sendEmailSync(properties.getEmailCampaign(), params.getEmail(), null, null, null, args, null);

            promoOrder.setStatus(Taxi2020PromoOrderStatus.EMAIL_SENT);
            promoOrder.setSentAt(Instant.now(clockService.getUtc()));
            log.info("Taxi 2020 promo code has been sent (asynchronously)");

            return null;
        }
    }

    @Value
    private static class PromoCodeEmailArgs {
        private String code;
    }
}
