package ru.yandex.travel.orders.services.promo.taxi2020;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.services.NotificationHelper;
import ru.yandex.travel.orders.services.YaSmsService;
import ru.yandex.travel.workflow.single_operation.SingleOperationRunner;

import static ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType.HOTEL_ORDER;

@Service
@RequiredArgsConstructor
@Slf4j
public class Taxi2020PromoSendSmsOperation implements SingleOperationRunner<Taxi2020PromoSendSmsData, Void> {
    private final Taxi2020PromoServiceProperties properties;
    private final YaSmsService yaSmsService;

    @Override
    public Class<Taxi2020PromoSendSmsData> getInputClass() {
        return Taxi2020PromoSendSmsData.class;
    }

    @Override
    public Void runOperation(Taxi2020PromoSendSmsData params) {
        try (NestedMdc ignored = NestedMdc.forEntity(params.getOrderId(), HOTEL_ORDER.getDiscriminatorValue())) {
            log.info("Starting the actual send sms call for Taxi 2020 promo order" + params.getOrderId());
            yaSmsService.sendSms(
                    String.format(properties.getSmsTextTemplate(), params.getPromoCode()),
                    NotificationHelper.normalizeFreeFormatPhone(params.getPhone())
            );
            log.info("Taxi 2020 promo code has been sent by sms");

            return null;
        }
    }
}
