package ru.yandex.travel.orders.services.promo.taxi2020;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.management.metrics.GaugeServiceDbMetric;
import ru.yandex.travel.orders.management.metrics.GaugeServiceSimpleDbMetric;
import ru.yandex.travel.orders.repository.promo.taxi2020.Taxi2020PromoCodeRepository;

@Configuration
public class Taxi2020PromoServiceMetricsConfiguration {
    @Bean
    public GaugeServiceDbMetric taxi2020freePromoCodesMetric(Taxi2020PromoCodeRepository repository) {
        return new GaugeServiceSimpleDbMetric("promoCampaigns.taxi2020", "freePromoCodes") {
            @Override
            public double getValue() {
                return repository.countByUsedAtIsNull();
            }
        };
    }
}
