package ru.yandex.travel.orders.services.promo.taxi2020;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(value = "promo.taxi2020", ignoreUnknownFields = false)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class Taxi2020PromoServiceProperties {
    @NotNull
    private Instant startsAt;
    @NotNull
    private Instant endsAt;
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @NotNull
    private LocalDate maxCheckInDate;
    @NotNull
    private String minPriceCurrency;
    @NotNull
    private BigDecimal minPriceValue;
    @NotEmpty
    private String emailCampaign;
    @NotNull
    private Integer maxProcessOrdersBatch;
    @NotNull
    private Duration emailScheduledAtOffset;
    @NotNull
    private Duration smsScheduledAtOffset;
    @NotEmpty
    private String smsTextTemplate;
    @NotNull
    private ZoneId defaultHotelTimeZoneId;
}
