package ru.yandex.travel.orders.services.promo.white_label;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.hotels.models.booking_flow.promo.PromoCampaignsInfo;
import ru.yandex.travel.hotels.models.booking_flow.promo.WhiteLabelPromoCampaign;
import ru.yandex.travel.hotels.proto.EWhiteLabelEligibility;
import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsRsp;
import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.services.PromoServiceHelper;
import ru.yandex.travel.orders.services.orders.OrderCompatibilityUtils;
import ru.yandex.travel.tx.utils.TransactionMandatory;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;

@Service
@RequiredArgsConstructor
@Slf4j
public class WhiteLabelPromoService {
    private final PromoServiceHelper promoServiceHelper;

    @TransactionMandatory
    public WhiteLabelPromoCampaign getPromoParticipationStatus(HotelOrder order) {
        HotelItinerary itinerary = OrderCompatibilityUtils.getOnlyHotelOrderItem(order).getHotelItinerary();
        if (Optional.ofNullable(itinerary.getActivePromoCampaigns())
                .map(PromoCampaignsInfo::getWhiteLabel).isEmpty()) {
            return null;
        }

        WhiteLabelPromoCampaign itineraryPromoCampaign = itinerary.getActivePromoCampaigns().getWhiteLabel();

        WhiteLabelPromoCampaign.WhiteLabelPromoCampaignBuilder builder = WhiteLabelPromoCampaign.builder()
                .eligible(itineraryPromoCampaign.getEligible());
        if (itineraryPromoCampaign.getEligible() == EWhiteLabelEligibility.WLE_ELIGIBLE) {
            builder.points(WhiteLabelPromoCampaign.WhiteLabelPoints.builder()
                            .pointsType(itineraryPromoCampaign.getPoints().getPointsType())
                            .amount(itineraryPromoCampaign.getPoints().getAmount())
                            .build())
                    .pointsLinguistics(getPointsLinguistics(
                            itineraryPromoCampaign.getPoints().getPointsType(),
                            itineraryPromoCampaign.getPoints().getAmount()));
        }
        return builder.build();
    }

    private WhiteLabelPromoCampaign.WhiteLabelPointsLinguistics getPointsLinguistics(EWhiteLabelPointsType pointsType,
                                                                                     int amount) {
        CompletableFuture<TGetWhiteLabelPointsPropsRsp> pointsPropsFuture = promoServiceHelper.getWhiteLabelPointsProps(pointsType, amount);

        TGetWhiteLabelPointsPropsRsp pointsProps = null;
        try {
            pointsProps = pointsPropsFuture.join();
        }
        catch (CompletionException ex) {
            log.error("Error during obtaining White Label points props from PromoService", ex);
        }
        if (pointsProps == null || !pointsProps.hasPointsLinguistics()) {
            return null;
        }
        return WhiteLabelPromoCampaign.WhiteLabelPointsLinguistics.builder()
                .nameForNumeralNominative(pointsProps.getPointsLinguistics().getNameForNumeralNominative())
                .build();
    }
}
