package ru.yandex.travel.orders.services.report;

import java.util.List;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "hotels-report", ignoreUnknownFields = false)
@Data
@Validated
public class HotelsReportProperties {

    private Mail mail;
    private Planner planner;

    @Data
    public static class Mail {
        private String payoutReportCampaign;
        private String ordersReportCampaign;
        private String paymentOrdersReportCampaign;
        private List<String> bccTargets;

        private boolean sendAccountingAct;
        private boolean sendPayoutReport;
        private boolean sendPaymentOrdersReport;

        private String emailOverride;
    }

    @Data
    public static class Planner {
        private boolean enabled;
        private String cronExpression;
    }
}
