package ru.yandex.travel.orders.services.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.google.common.io.Resources;
import lombok.extern.slf4j.Slf4j;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.services.report.model.PartnerOrdersReport;
import ru.yandex.travel.orders.services.report.model.PartnerPaymentOrdersReport;
import ru.yandex.travel.orders.services.report.model.PartnerPayoutsReport;

@Slf4j
@Service
public class PartnerXlsReportGenerator {

    /**
     * Генерация Отчета Агента
     */
    public void generatePayoutReport(String sheetName, PartnerPayoutsReport data, OutputStream out) {
        try (InputStream is =
                     Resources.getResource("reports/templates/hotels/partner_payouts.xlsx").openStream()) {
            Context context = new Context();
            context.putVar("data", data);
            JxlsHelper.getInstance().setDeleteTemplateSheet(true)
                    .processTemplateAtCell(is, out, context, sheetName + "!A1");
        } catch (IOException e) {
            throw new RuntimeException("Error generating payout report", e);
        }
    }

    /**
     * Генерация Акта об оказанных Услугах
     */
    public void generateOrdersReport(String sheetName, PartnerOrdersReport data, OutputStream out) {
        try (InputStream is = Resources.getResource("reports/templates/hotels/partner_orders.xlsx").openStream()) {
            Context context = new Context();
            context.putVar("data", data);
            JxlsHelper.getInstance().setDeleteTemplateSheet(true)
                    .processTemplateAtCell(is, out, context, sheetName + "!A1");
        } catch (IOException e) {
            throw new RuntimeException("Error generating orders report", e);
        }
    }

    /**
     * Генерация расшифровки платежного поручения
     */
    public void generatePaymentOrdersReport(String sheetName, PartnerPaymentOrdersReport data, OutputStream out) {
        try (InputStream is =
                     Resources.getResource("reports/templates/hotels/partner_payment_orders.xlsx").openStream()) {
            Context context = new Context();
            context.putVar("data", data);
            JxlsHelper.getInstance().setDeleteTemplateSheet(true)
                    .processTemplateAtCell(is, out, context, sheetName + "!A1");
        } catch (IOException e) {
            throw new RuntimeException("Error generating payment orders report", e);
        }
    }

}
