package ru.yandex.travel.orders.services.report;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;

public class ReportDateHelper {
    private static final DateTimeFormatter REGULAR_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public static String getMonthYearText(LocalDate from) {
        return from.getMonth().getDisplayName(TextStyle.FULL_STANDALONE, new Locale("ru")) + " " + from.getYear();
    }

    public static String getDayMonthYearText(LocalDate from) {
        return from.getDayOfMonth() + " " + getMonthYearText(from);
    }

    public static String getDayMonthYearStandard(LocalDate from) {
        return String.format("%1$td.%1$tm.%1$ty", from);
    }

    public static String getDayMonthYearStandard(Instant from) {
        return REGULAR_DATE_FORMATTER.format(LocalDate.ofInstant(from, ZoneOffset.UTC));
    }

    public static String getMonthYearText(Instant from) {
        return getMonthYearText(LocalDate.ofInstant(from, ZoneOffset.UTC));
    }
}
