package ru.yandex.travel.orders.services.report.model;

import java.time.LocalDate;
import java.util.List;

import lombok.Data;

@Data
public abstract class CommonPartnerReportDTO<T extends CommonPartnerReportDTO.CommonTransactionRow> {
    private String reportName;
    private List<T> transactions;

    @Data
    public abstract static class CommonTransactionRow {
        private String hotelName;
        private String prettyId;
        private String partnerId;
        private String guestName;
        private LocalDate bookedAt;
        private LocalDate checkIn;
        private LocalDate checkOut;
        private Double totalAmount;
        private Double partnerAmount;
    }
}
