package ru.yandex.travel.orders.services.report.model;

import java.math.BigDecimal;
import java.time.LocalDate;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Реестр завершенных бронирований
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PartnerOrdersReport extends CommonPartnerReportDTO<PartnerOrdersReport.TransactionRow> {

    private LocalDate reportPeriodFrom;
    private LocalDate reportPeriodTo;

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class TransactionRow extends CommonTransactionRow {
        private String type;
        private double feeAmount;
        private int commissionRate;

        public void setCommissionRate(BigDecimal originalFee) {
            commissionRate = originalFee.multiply(new BigDecimal(100)).intValue();
        }
    }
}
