package ru.yandex.travel.orders.services.report.model;

import java.time.LocalDate;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class PartnerPayoutsReport extends CommonPartnerReportDTO<PartnerPayoutsReport.TransactionRow> {
    private String contractData;
    private LocalDate reportPeriodFrom;
    private LocalDate reportPeriodTo;
    private Double balanceAtStartOfMonth;
    private Double balanceAtEndOfMonth;
    private Double transferAmount;
    private Double transferredAmount;

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class TransactionRow extends CommonTransactionRow {
        private String txType;
        private LocalDate txDate;
        private Double totalRefundAmount;
        private LocalDate paymentDate;
        private String paymentOrderNumber;
        private double feeAmount;
    }
}
