package ru.yandex.travel.orders.services.suburban.environment;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.services.DeduplicationService;
import ru.yandex.travel.orders.services.suburban.providers.AeroexpressProvider;
import ru.yandex.travel.orders.services.suburban.providers.ImProvider;
import ru.yandex.travel.orders.services.suburban.providers.MovistaProvider;
import ru.yandex.travel.orders.services.suburban.providers.SuburbanProviderBase;
import ru.yandex.travel.orders.workflows.orderitem.suburban.SuburbanProperties;
import ru.yandex.travel.suburban.partners.SuburbanProvider;
import ru.yandex.travel.suburban.partners.aeroexpress.AeroexpressClient;
import ru.yandex.travel.suburban.partners.movista.MovistaClient;
import ru.yandex.travel.train.partners.im.ImClient;


@Slf4j
@RequiredArgsConstructor
public class SuburbanOrderItemEnv {
    /*
    Окружение для процесса продаж электричек для конкретного заказа.

    Используется для управления "миром", в котором живет конкретный заказ -
    например, окружение с тестовым контекстом перегрузит клиента к АПИ партнера,
    чтобы работать по заранее заданному тестовому сценарию.
    */

    protected final SuburbanOrderItem orderItem;
    protected final SuburbanProperties props;
    protected final DeduplicationService deduplicationService;

    @Getter
    protected final MovistaClient movistaClient;

    @Getter
    protected final ImClient imSuburbanClient;

    @Getter
    protected final AeroexpressClient aeroexpressClient;

    public SuburbanProviderBase createSuburbanProvider() {
        if (orderItem.getReservation().getProvider() == SuburbanProvider.MOVISTA) {
            return new MovistaProvider(orderItem, props, this);
        } else if (orderItem.getReservation().getProvider() == SuburbanProvider.IM) {
            return new ImProvider(orderItem, props, this, deduplicationService);
        } else if (orderItem.getReservation().getProvider() == SuburbanProvider.AEROEXPRESS) {
            return new AeroexpressProvider(orderItem, props, this);
        } else {
            throw new RuntimeException(String.format("Unknown provider %s", orderItem.getReservation().getProvider()));
        }
    }
}
