package ru.yandex.travel.orders.services.support.jobs;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import ru.yandex.travel.orders.services.support.HotelsSupportNotificationService;

@Slf4j
@DisallowConcurrentExecution
public class ScheduleSuccessfulHotelOrderNotificationsJob extends QuartzJobBean {
    @Autowired
    @Setter
    private HotelsSupportNotificationService hotelsSupportNotificationService;

    @Override
    protected void executeInternal(JobExecutionContext context) {
        hotelsSupportNotificationService.scheduleNewSuccessfulOrders();
    }
}
