package ru.yandex.travel.orders.services.support.jobs;

import java.util.UUID;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.services.support.HotelsSupportNotificationService;

@Slf4j
@DisallowConcurrentExecution
public class SendSuccessfulHotelOrderNotificationsJob extends QuartzJobBean {
    @Autowired
    @Setter
    private HotelsSupportNotificationService hotelsSupportNotificationService;

    @Override
    protected void executeInternal(JobExecutionContext context) {
        for (UUID orderId : hotelsSupportNotificationService.findPendingSuccessfulHotelOrderNotifications()) {
            try (NestedMdc ignored = NestedMdc.forEntityId(orderId)) {
                try {
                    hotelsSupportNotificationService.sendSuccessfulHotelOrderNotification(orderId);
                } catch (Exception e) {
                    log.warn("Failed to send a successful hotel order notification", e);
                }
            }
        }
    }
}
