package ru.yandex.travel.orders.services.support.jobs;

import java.util.List;
import java.util.UUID;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import ru.yandex.travel.orders.services.support.HotelsSupportNotificationService;

@Slf4j
@DisallowConcurrentExecution
public class SendUnsuccessfulHotelOrderNotificationsJob extends QuartzJobBean {
    @Autowired
    @Setter
    private HotelsSupportNotificationService hotelsSupportNotificationService;

    @Override
    protected void executeInternal(JobExecutionContext context) {
        for (List<UUID> notificationGroup : hotelsSupportNotificationService.findPendingUnsuccessfulHotelOrderNotifications()) {
            try {
                hotelsSupportNotificationService.sendUnsuccessfulHotelOrderNotification(notificationGroup);
            } catch (Exception e) {
                log.warn("Failed to send an unsuccessful hotel order notification", e);
            }
        }
    }
}
