package ru.yandex.travel.orders.services.takeout;

import java.time.Duration;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "takeout", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class TakeoutProperties {
    @NotNull
    private Duration taskInitialStartDelay;
    @NotNull
    private Duration taskPeriod;
    @Positive
    private int taskNumberOfItems;
    @NotNull
    private Boolean enableGenericOrdersMode;
}
