package ru.yandex.travel.orders.services.train;

import java.util.List;
import java.util.stream.Collectors;

import javax.transaction.Transactional;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.TrainCustomerInfo;
import ru.yandex.travel.orders.repository.TrainCustomerInfoRepository;
import ru.yandex.travel.train.model.CustomerInfo;
import ru.yandex.travel.train.partners.im.CustomerInfoRepository;

@Service
@Slf4j
@RequiredArgsConstructor
public class CustomerInfoRepositoryImpl implements CustomerInfoRepository {
    private final TrainCustomerInfoRepository trainCustomerInfoRepository;

    @Override
    @Transactional
    public List<CustomerInfo> getByOrderId(Integer orderId) {
        return trainCustomerInfoRepository.findByOrderId(orderId).stream()
                .map(CustomerInfoRepositoryImpl::toCustomerInfo).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public List<CustomerInfo> getByBuyOperationId(Integer orderItemId) {
        return trainCustomerInfoRepository.findByBuyOperationId(orderItemId).stream()
                .map(CustomerInfoRepositoryImpl::toCustomerInfo).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public CustomerInfo getOne(Integer customerId) {
        return trainCustomerInfoRepository.findById(customerId)
                .map(CustomerInfoRepositoryImpl::toCustomerInfo).orElse(null);
    }

    @Override
    @Transactional
    public void save(List<CustomerInfo> customerInfoList) {
        trainCustomerInfoRepository.saveAll(customerInfoList.stream()
                .map(TrainCustomerInfo::new).collect(Collectors.toList()));
    }

    private static CustomerInfo toCustomerInfo(TrainCustomerInfo source) {
        return new CustomerInfo(
                source.getCustomerId(),
                source.getOrderId(),
                source.getBuyOperationId(),
                source.getFirstName(),
                source.getMiddleName(),
                source.getLastName());
    }
}
