package ru.yandex.travel.orders.services.train;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import lombok.Getter;
import org.springframework.stereotype.Component;

@Component
public class TrainMeters {
    @Getter
    private final Counter trainOrdersRebookingCreated =
            Counter.builder("orders.train.rebooking.created").register(Metrics.globalRegistry);
    @Getter
    private final Counter trainOrdersRebookingInvalid =
            Counter.builder("orders.train.rebooking.invalid").register(Metrics.globalRegistry);
    @Getter
    private final Counter trainOrdersRebookingInsuranceFailed =
            Counter.builder("orders.train.rebooking.insurancefailed").register(Metrics.globalRegistry);
    @Getter
    private final Counter trainOrdersBanditErrors =
            Counter.builder("orders.train.bandit.errors").register(Metrics.globalRegistry);
    @Getter
    private final Counter trainOrdersBanditFallbacks =
            Counter.builder("orders.train.bandit.fallbacks").register(Metrics.globalRegistry);
}
