package ru.yandex.travel.orders.services.train.bandit;

import java.util.Set;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.services.train.TrainMeters;
import ru.yandex.travel.train_bandit_api.proto.BanditApiServiceV1Grpc;
import ru.yandex.travel.train_bandit_api.proto.TGetChargeByTokenRequest;
import ru.yandex.travel.train_bandit_api.proto.TGetChargeByTokenResponse;
import ru.yandex.travel.train_bandit_api.proto.TGetChargeStringCtxRequest;
import ru.yandex.travel.train_bandit_api.proto.TGetChargeStringCtxResponse;

@Service
@Slf4j
@RequiredArgsConstructor
public class TrainBanditClient {
    private final static Set<Status.Code> RETRYABLE_STATUSES = Set.of(
            Status.Code.UNAVAILABLE, Status.Code.INTERNAL, Status.Code.DEADLINE_EXCEEDED
    );

    private final BanditApiServiceV1Grpc.BanditApiServiceV1BlockingStub banditStub;
    private final TrainMeters meters;

    public TGetChargeStringCtxResponse getCharge(TGetChargeStringCtxRequest request) {
        try {
            return banditStub.getChargeStringContext(request);
        } catch (StatusRuntimeException ex) {
            meters.getTrainOrdersBanditErrors().increment();
            if (RETRYABLE_STATUSES.contains(ex.getStatus().getCode())){
                throw new TrainBanditRetryableException(ex);
            }
            throw ex;
        }
    }

    public TGetChargeByTokenResponse getChargeByToken(TGetChargeByTokenRequest request) {
        try {
            return banditStub.getChargeByToken(request);
        } catch (StatusRuntimeException ex) {
            meters.getTrainOrdersBanditErrors().increment();
            if (RETRYABLE_STATUSES.contains(ex.getStatus().getCode())){
                throw new TrainBanditRetryableException(ex);
            }
            throw ex;
        }
    }
}
