package ru.yandex.travel.orders.services.train.bandit;

import java.math.BigDecimal;
import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;


@ConfigurationProperties(value = "train-bandit", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class TrainBanditProperties {
    @NotEmpty
    private String target;

    @NotNull
    private Duration timeout;

    private Tvm tvm;

    private boolean enabled;

    private int maxTriesToFallback;

    private int localPermille;

    private BigDecimal localPartnerFee;

    private BigDecimal localPartnerRefundFee;

    private BigDecimal localMinFeeFactor;

    @Getter
    @Setter
    @Validated
    public static class Tvm {
        private boolean enabled;
        @NotEmpty
        private String destinationAlias;
    }
}
