package ru.yandex.travel.orders.services.train.tariffinfo;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("train-tariff-info")
public class TrainTariffInfoDataProviderHealthIndicator implements HealthIndicator {
    private final TrainTariffInfoDataProvider trainTariffInfoDataProvider;

    @Override
    public Health health() {
        if (trainTariffInfoDataProvider.isReady()) {
            return Health.up().build();
        }

        return Health.down().build();
    }
}
