package ru.yandex.travel.orders.workflows.attachment;

import com.google.common.collect.ImmutableMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.services.attachments.AttachmentProviderService;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;
import ru.yandex.travel.orders.workflow.notification.proto.EAttachmentState;
import ru.yandex.travel.orders.workflows.attachment.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.notification.NotificationWorkflowProperties;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
public class AttachmentWorkflowConfiguration {
    @Bean
    public WorkflowEventHandler<Attachment> attachmentWorkflowEventHandler(
            AttachmentProviderService attachmentProviderService,
            EntityStateTransitionRepository entityStateTransitionRepository,
            NotificationWorkflowProperties notificationWorkflowProperties,
            S3Service s3Service
    ) {
        ImmutableMap.Builder<EAttachmentState, StatefulWorkflowEventHandler<EAttachmentState, Attachment>> builder =
                ImmutableMap.builder();
        builder.put(EAttachmentState.AS_NEW, new NewStateHandler(
                attachmentProviderService, notificationWorkflowProperties, s3Service));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
