package ru.yandex.travel.orders.workflows.attachment.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.services.attachments.AttachmentProviderService;
import ru.yandex.travel.orders.services.attachments.AttachmentsHelper;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;
import ru.yandex.travel.orders.workflow.notification.proto.EAttachmentState;
import ru.yandex.travel.orders.workflow.notification.proto.TAttachmentFetchStart;
import ru.yandex.travel.orders.workflow.notification.proto.TAttachmentFetched;
import ru.yandex.travel.orders.workflows.notification.NotificationWorkflowProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.exceptions.RetryableException;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAttachmentState, Attachment> {
    private final AttachmentProviderService attachmentProviderService;
    private final NotificationWorkflowProperties notificationWorkflowProperties;
    private final S3Service s3Service;

    @HandleEvent
    public void handleFetchAttachment(TAttachmentFetchStart event, StateContext<EAttachmentState, Attachment> context) {
        Attachment attachment = context.getWorkflowEntity();
        byte[] data;
        try {
            data = attachmentProviderService.getAttachmentData(attachment);
        } catch (RetryableException ex) {
            throw new RetryableException(ex, notificationWorkflowProperties.getFetchAttachmentRetryDuration());
        }
        AttachmentsHelper.storeAttachmentData(attachment, data, s3Service);
        context.setState(EAttachmentState.AS_FETCHED);
        context.scheduleExternalEvent(attachment.getNotificationWorkflowId(),
                TAttachmentFetched.newBuilder().setAttachmentId(attachment.getId().toString()).build());
    }
}
