package ru.yandex.travel.orders.workflows.invoice.aeroflot;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.AeroflotInvoice;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceCancelledStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceCreateTrustBasketStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceNewStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceTimedOutStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceWaitConfirmationStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceWaitOrderCreatedStateHandler;
import ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers.AeroflotInvoiceWaitTrustTokenizationStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
public class AeroflotInvoiceWorkflowConfiguration {

    @Autowired
    private EntityStateTransitionRepository entityStateTransitionRepository;

    @Autowired
    private AeroflotInvoiceNewStateHandler newStateHandler;
    @Autowired
    private AeroflotInvoiceCreateTrustBasketStateHandler createTrustBasketHandler;
    @Autowired
    private AeroflotInvoiceWaitTrustTokenizationStateHandler waitTrustTokenizationHandler;
    @Autowired
    private AeroflotInvoiceWaitOrderCreatedStateHandler waitOrderCreatedHandler;
    @Autowired
    private AeroflotInvoiceWaitConfirmationStateHandler waitConfirmationHandler;
    @Autowired
    private AeroflotInvoiceConfirmedStateHandler confirmedHandler;
    @Autowired
    private AeroflotInvoiceTimedOutStateHandler timedOutHandler;
    @Autowired
    private AeroflotInvoiceCancelledStateHandler cancelledHandler;

    @Bean
    public WorkflowEventHandler aeroflotInvoiceWorkflowEventHandler() {
        return new ProxyStateMapWorkflowEventHandler<>(ImmutableMap
                .<EAeroflotInvoiceState, StatefulWorkflowEventHandler<EAeroflotInvoiceState, AeroflotInvoice>>builder()
                .put(EAeroflotInvoiceState.IS_NEW, newStateHandler)
                .put(EAeroflotInvoiceState.IS_CREATE_TRUST_BASKET, createTrustBasketHandler)
                .put(EAeroflotInvoiceState.IS_WAIT_TRUST_TOKENIZATION, waitTrustTokenizationHandler)
                .put(EAeroflotInvoiceState.IS_WAIT_ORDER_CREATED, waitOrderCreatedHandler)
                .put(EAeroflotInvoiceState.IS_WAIT_CONFIRMATION, waitConfirmationHandler)
                .put(EAeroflotInvoiceState.IS_CONFIRMED, confirmedHandler)
                .put(EAeroflotInvoiceState.IS_TIMED_OUT, timedOutHandler)
                .put(EAeroflotInvoiceState.IS_CANCELLED, cancelledHandler)
                .build(), entityStateTransitionRepository);
    }
}
