package ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers;

import java.time.Instant;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotInvoice;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.orders.workflow.invoice.proto.TPaymentCreated;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.configuration.AeroflotWorkflowProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@RequiredArgsConstructor
@Slf4j
public class AeroflotInvoiceNewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotInvoiceState, AeroflotInvoice> {
    private final AeroflotWorkflowProperties properties;

    @HandleEvent
    public void onEvent(TPaymentCreated event, StateContext<EAeroflotInvoiceState, AeroflotInvoice> stateContext) {
        Instant expiresAt = Instant.now().plus(properties.getInvoiceTrustTimeout());
        log.info("Starting aeroflot payment process; expires at {}", expiresAt);
        EAeroflotOrderState orderState = stateContext.getWorkflowEntity().getOrder().getEntityState();
        Preconditions.checkArgument(orderState == EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED,
                "The order isn't ready for payment yet! orderState=%s, expected=%s",
                orderState, EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED);
        // todo(tlg-13): should be integrated with the order.expiresAt property (which should be based on order items)
        stateContext.getWorkflowEntity().setExpirationDate(expiresAt);
        stateContext.setState(EAeroflotInvoiceState.IS_CREATE_TRUST_BASKET);
        stateContext.scheduleEvent(event);
    }
}
