package ru.yandex.travel.orders.workflows.invoice.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotInvoice;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.TAeroflotInvoiceExternalConfirmationOfCancelled;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotInvoiceAutoRestored;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Service
@Slf4j
@IgnoreEvents
public class AeroflotInvoiceTimedOutStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EAeroflotInvoiceState, AeroflotInvoice> {
    @HandleEvent
    public void onExternalConfirmation(TAeroflotInvoiceExternalConfirmationOfCancelled event,
                                       StateContext<EAeroflotInvoiceState, AeroflotInvoice> ctx) {
        log.info("Confirming timed out invoice");
        ctx.setState(EAeroflotInvoiceState.IS_CONFIRMED);
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOrderWorkflowId(),
                TAeroflotInvoiceAutoRestored.newBuilder().build());
    }
}
