package ru.yandex.travel.orders.workflows.invoice.refund;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.SimpleTrustRefund;
import ru.yandex.travel.orders.workflow.trust.refund.proto.ETrustRefundState;
import ru.yandex.travel.orders.workflows.invoice.refund.handlers.CreateStateHandler;
import ru.yandex.travel.orders.workflows.invoice.refund.handlers.InProcessStateHandler;
import ru.yandex.travel.orders.workflows.invoice.refund.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.invoice.refund.handlers.StartStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.IgnoreMessagesHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
public class TrustRefundWorkflowConfiguration {

    @Autowired
    private EntityStateTransitionRepository entityStateTransitionRepository;

    @Autowired
    private NewStateHandler newStateHandler;

    @Autowired
    private CreateStateHandler createStateHandler;

    @Autowired
    private StartStateHandler startStateHandler;

    @Autowired
    private InProcessStateHandler inProcessStateHandler;

    @Autowired
    private IgnoreMessagesHandler ignoreMessagesHandler;

    @Bean
    public WorkflowEventHandler trustRefundWorkflowEventHandler() {
        ImmutableMap.Builder<ETrustRefundState, StatefulWorkflowEventHandler<ETrustRefundState, SimpleTrustRefund>> builder = ImmutableMap.builder();
        builder.put(ETrustRefundState.RS_NEW, newStateHandler);
        builder.put(ETrustRefundState.RS_CREATE, createStateHandler);
        builder.put(ETrustRefundState.RS_START, startStateHandler);
        builder.put(ETrustRefundState.RS_IN_PROCESS, inProcessStateHandler);
        // types messages for terminal states
        builder.put(ETrustRefundState.RS_ERROR, ignoreMessagesHandler);
        builder.put(ETrustRefundState.RS_FAILED, ignoreMessagesHandler);
        builder.put(ETrustRefundState.RS_SUCCESS, ignoreMessagesHandler);
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
