package ru.yandex.travel.orders.workflows.invoice.refund.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.SimpleTrustRefund;
import ru.yandex.travel.orders.workflow.trust.refund.proto.ETrustRefundState;
import ru.yandex.travel.orders.workflow.trust.refund.proto.TCreateRefund;
import ru.yandex.travel.orders.workflow.trust.refund.proto.TRefundCreated;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service("refundNewStateHandler")
@Slf4j
@RequiredArgsConstructor
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETrustRefundState, SimpleTrustRefund> {

    @HandleEvent
    public void handleRefundCreated(TRefundCreated message,
                                    StateContext<ETrustRefundState, SimpleTrustRefund> ctx) {
        ctx.setState(ETrustRefundState.RS_CREATE);
        ctx.scheduleEvent(TCreateRefund.newBuilder().build());
    }

}
