package ru.yandex.travel.orders.workflows.invoice.refund.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.Invoice;
import ru.yandex.travel.orders.entities.SimpleTrustRefund;
import ru.yandex.travel.orders.services.payments.TrustClientProvider;
import ru.yandex.travel.orders.services.payments.TrustUserInfo;
import ru.yandex.travel.orders.workflow.trust.refund.proto.ETrustRefundState;
import ru.yandex.travel.orders.workflow.trust.refund.proto.TStartRefund;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.TrustUserInfoHelper;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class StartStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETrustRefundState, SimpleTrustRefund> {

    private final TrustClientProvider trustClientProvider;

    public StartStateHandler(TrustClientProvider trustClientProvider) {
        this.trustClientProvider = trustClientProvider;
    }

    @HandleEvent
    public void handleCreateRefund(TStartRefund message,
                                   StateContext<ETrustRefundState, SimpleTrustRefund> ctx) {

        SimpleTrustRefund refund = ctx.getWorkflowEntity();
        Invoice invoice = refund.getInvoice();
        TrustUserInfo trustUserInfo = TrustUserInfoHelper.createUserInfo(invoice);
        trustClientProvider.getTrustClientForPaymentProfile(invoice.getPaymentProfile())
                .startRefund(ctx.getWorkflowEntity().getTrustRefundId(), trustUserInfo);
        refund.rescheduleNextRefreshAt();
        ctx.setState(ETrustRefundState.RS_IN_PROCESS);
    }
}
